#!/bin/bash
export CUDA_VISIBLE_DEVICES=2
log_dir="./results/log"
log_file="$log_dir/embedding.out"
mkdir -p "$log_dir"
exec >"$log_file" 2>&1
datasets=('mgsm')
model_names=("all-roberta-large-v1")

for dataset in "${datasets[@]}"; do
  for model_name in "${model_names[@]}"; do
    cmd="python embedding.py --dataset $dataset --model_name $model_name --if_qwa"
    echo $cmd
    $cmd

    cmd="python embedding.py --dataset $dataset --model_name $model_name"
    echo $cmd
    $cmd
  done
done
